/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.service.webmap.Webmap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<class_5250> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(class_2561 chat) {
        class_5250 wrap = class_2561.method_43469((String)"jm.common.chat_announcement", (Object[])new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        class_5250 chat = Constants.getStringTextComponent(message);
        chat.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url)));
        chat.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Constants.getStringTextComponent(url))));
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceFile(String message, File file) {
        class_5250 chat = Constants.getStringTextComponent(message);
        try {
            String path = file.getCanonicalPath();
            chat.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, path)));
            chat.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Constants.getStringTextComponent(path))));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        class_5250 chat = Constants.getStringTextComponent(text);
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement(chat);
    }

    public static void showChatAnnouncements(class_310 mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getInstance().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            class_5250 message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_1705.method_1743().method_1812((class_2561)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, class_3544.method_15440((String)message.getString()));
                    throw throwable;
                }
                logLevel = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, class_3544.method_15440((String)message.getString()));
                continue;
            }
            logLevel = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, class_3544.method_15440((String)message.getString()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = JourneymapClient.getInstance().getKeyEvents().getHandler().kbFullscreenToggle.method_16007().getString().toUpperCase();
            if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                try {
                    Webmap webServer = JourneymapClient.getInstance().getJmServer();
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    implements class_2561 {
        String text;

        public ErrorChat(String text) {
            this.text = text;
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_8828.method_54232((String)this.text);
        }

        public List<class_2561> method_10855() {
            return Lists.newArrayList();
        }

        public class_5481 method_30937() {
            return class_5481.field_26385;
        }
    }
}

