/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.List;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class ScrollListPane<T extends Slot>
extends class_350 {
    private final JmUI parent;
    public SlotMetadata lastTooltipMetadata;
    public List<class_5481> lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    protected int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    protected int lastClickedIndex;
    protected int scrollbarX;
    protected int listWidth;
    private boolean alignTop;

    public ScrollListPane(JmUI parent, class_310 mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, y, width, height, slotHeight);
        this.parent = parent;
        this.updateSize(width, height, x, y);
    }

    public void updateSize(int width, int height, int x, int y) {
        super.method_55444(width, height - y, x, y);
        this.scrollbarX = this.field_22758 - this.hpad;
        this.listWidth = this.field_22758 - this.hpad * 4;
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.method_25340();
        this.method_25396().clear();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
            super.method_25321((class_350.class_351)slot);
            List<? extends Slot> childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            for (Slot slot2 : childSlots) {
                super.method_25321((class_350.class_351)slot2);
            }
        }
        int sizeAfter = this.method_25340();
        if (sizeBefore < sizeAfter) {
            this.method_25309(-(sizeAfter * this.field_22741));
            this.method_25309(this.lastClickedIndex * this.field_22741);
        }
    }

    public void scrollTo(Slot slot) {
        this.method_25309(-(this.method_25396().size() * this.field_22759));
        this.method_25309(this.method_25396().indexOf((Object)slot) * this.field_22759);
    }

    public boolean method_25332(int index) {
        return super.method_25332(index);
    }

    protected int method_25337(int slotIndex) {
        return super.method_25337(slotIndex);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            SlotMetadata tooltipMetadata;
            super.method_31322(false);
            Slot slot = (Slot)this.method_25308(mouseX, mouseY);
            if (slot != null && (tooltipMetadata = slot.getCurrentTooltip()) != null && !tooltipMetadata.getTooltip().equals(this.lastTooltip)) {
                this.lastTooltipMetadata = tooltipMetadata;
                this.lastTooltip = tooltipMetadata.getTooltip();
                this.lastTooltipTime = System.currentTimeMillis();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_25311(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25311(graphics, mouseX, mouseY, partialTicks);
    }

    public int method_25322() {
        return this.listWidth;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (super.method_25405(mouseX, mouseY)) {
            Slot slot = (Slot)this.method_25308(mouseX, mouseY);
            if (slot == null) {
                return false;
            }
            this.lastClickedIndex = this.method_25396().indexOf((Object)slot);
            this.lastPressed = slot.getLastPressed();
            if (slot instanceof CategorySlot) {
                this.updateSlots();
            }
        }
        return clicked;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        for (int slotIndex = 0; slotIndex < this.method_25340(); ++slotIndex) {
            Slot slot;
            if (slotIndex != this.lastClickedIndex || !(slot = this.getSlot(this.lastClickedIndex)).method_25406(mouseX, mouseY, mouseButton)) continue;
            this.lastPressed = null;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.method_25396().isEmpty()) {
            return false;
        }
        if (this.lastClickedIndex > -1 && this.getSlot(this.lastClickedIndex) != null && this.getSlot(this.lastClickedIndex).method_25403(mouseX, mouseY, button, mouseDX, mouseDY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public Slot getSlot(int index) {
        if (super.method_25340() > index) {
            return (Slot)((Object)this.method_25396().get(index));
        }
        return null;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        for (int slotIndex = 0; slotIndex < this.method_25340(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).method_25400(typedChar, keyCode);
        }
        return false;
    }

    public boolean method_25404(int key, int value, int modifier) {
        for (int slotIndex = 0; slotIndex < this.method_25340(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).method_25404(key, value, modifier);
        }
        return false;
    }

    protected int method_25329() {
        return this.scrollbarX;
    }

    protected void renderBackground(class_332 graphics, int i, int j, float f) {
        graphics.method_25296(0, 0, this.field_22758, this.field_22759 + this.method_46427(), -1072689136, -804253680);
    }

    protected int method_25317() {
        int contentHeight = super.method_25317();
        if (this.alignTop) {
            contentHeight = Math.max(this.method_55443() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int method_25331() {
        return Math.max(0, this.method_25317() - (this.field_22759 - 4));
    }

    public int getTop() {
        return super.method_46427();
    }

    public int method_25364() {
        return this.field_22759;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

