/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.network.data.model.ClientState;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ClientPermissionsPacket
implements ClientState {
    public static final class_2960 CHANNEL = new class_2960("journeymap", "perm_req");
    private String payload;
    private boolean serverAdmin;
    private boolean hasServerMod = false;

    public ClientPermissionsPacket() {
        this.payload = "";
    }

    public ClientPermissionsPacket(String payload, boolean serverAdmin, boolean hasServerMod) {
        this.payload = payload;
        this.serverAdmin = serverAdmin;
        this.hasServerMod = hasServerMod;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    @Override
    public boolean hasServerMod() {
        return this.hasServerMod;
    }

    public static ClientPermissionsPacket decode(class_2540 buf) {
        ClientPermissionsPacket packet = new ClientPermissionsPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.serverAdmin = buf.readBoolean();
                packet.payload = buf.method_10800(Short.MAX_VALUE);
                try {
                    packet.hasServerMod = buf.readBoolean();
                }
                catch (Exception e) {
                    Journeymap.getLogger().debug("Permission set from external source.");
                    packet.hasServerMod = false;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for client permissions: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            if (this.payload != null) {
                buf.method_52997(42);
                buf.method_52964(this.serverAdmin);
                buf.method_10814(this.payload);
                buf.method_52964(this.hasServerMod);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for client permissions:" + t);
        }
    }

    public static void handle(PacketContext<ClientPermissionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onClientPermsRequest(ctx.sender());
        } else {
            JourneymapClient.getInstance().getPacketHandler().onClientStateUpdate(ctx.message());
        }
    }
}

