/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.compat;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.compat.EmptyMixinPlugin;
import me.modmuss50.optifabric.compat.InterceptingMixin;
import me.modmuss50.optifabric.compat.LoudCoerce;
import me.modmuss50.optifabric.compat.PlacatingSurrogate;
import me.modmuss50.optifabric.compat.Shim;
import me.modmuss50.optifabric.util.MixinUtils;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Annotations;

public class InterceptingMixinPlugin
extends EmptyMixinPlugin {
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode thisMixin = MixinUtils.Mixin.create(mixinInfo).getClassNode();
        AnnotationNode interception = Annotations.getInvisible((ClassNode)thisMixin, InterceptingMixin.class);
        if (interception == null) {
            return;
        }
        MixinUtils.Mixin interceptionMixin = InterceptingMixinPlugin.findMixin(targetClassName, Annotations.getValue((AnnotationNode)interception, (String)"value", (boolean)true));
        block0: for (MethodNode method : thisMixin.methods) {
            AnnotationNode surrogateNode = Annotations.getInvisible((MethodNode)method, PlacatingSurrogate.class);
            if (surrogateNode == null) continue;
            for (ClassInfo.Method realMethod : interceptionMixin.getMethods()) {
                if (!realMethod.getOriginalName().equals(method.name)) continue;
                Annotations.setInvisible((MethodNode)method, From.class, (Object[])new Object[]{"method", method.name.concat(method.desc)});
                method.name = realMethod.getName();
                method.invisibleAnnotations.remove(surrogateNode);
                Annotations.setVisible((MethodNode)method, Surrogate.class, (Object[])new Object[0]);
                String coercedDesc = InterceptingMixinPlugin.coerceDesc(method);
                if (coercedDesc != null) {
                    method.desc = coercedDesc;
                }
                assert (Modifier.isStatic(method.access) == realMethod.isStatic());
                targetClass.methods.add(method);
                continue block0;
            }
            throw new IllegalStateException("Cannot find original Mixin method for surrogate " + method.name + method.desc + " in " + interceptionMixin);
        }
    }

    private static MixinUtils.Mixin findMixin(String targetClass, Collection<String> mixinTargets) {
        mixinTargets = ImmutableSet.copyOf(mixinTargets);
        for (MixinUtils.Mixin mixin : MixinUtils.getMixinsFor(targetClass)) {
            if (!mixinTargets.contains(mixin.getName())) continue;
            return mixin;
        }
        throw new IllegalArgumentException("Can't find Mixin class" + (mixinTargets.size() != 1 ? "es " : Character.valueOf(' ')) + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)mixinTargets) + " targetting " + targetClass);
    }

    protected static String coerceDesc(MethodNode method) {
        if (method.invisibleParameterAnnotations != null) {
            Type[] arguments = Type.getArgumentTypes((String)method.desc);
            boolean madeChange = false;
            int end = arguments.length;
            for (int i = 0; i < end; ++i) {
                AnnotationNode coercionNode = Annotations.getInvisibleParameter((MethodNode)method, LoudCoerce.class, (int)i);
                if (coercionNode == null) continue;
                String type = (String)Annotations.getValue((AnnotationNode)coercionNode);
                if (Annotations.getValue((AnnotationNode)coercionNode, (String)"remap") != Boolean.FALSE) {
                    type = RemappingUtils.getClassName(type);
                }
                arguments[i] = Type.getObjectType((String)type);
                madeChange = true;
            }
            if (madeChange) {
                return Type.getMethodDescriptor((Type)Type.getReturnType((String)method.desc), (Type[])arguments);
            }
        }
        return null;
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode thisMixin = MixinUtils.Mixin.create(mixinInfo).getClassNode();
        AnnotationNode interception = Annotations.getInvisible((ClassNode)thisMixin, InterceptingMixin.class);
        if (interception == null) {
            return;
        }
        MixinUtils.Mixin interceptionMixin = InterceptingMixinPlugin.findMixin(targetClassName, Annotations.getValue((AnnotationNode)interception, (String)"value", (boolean)true));
        Map<String, ClassInfo.Method> shims = thisMixin.methods.stream().filter(method -> Annotations.getInvisible((MethodNode)method, Shim.class) != null).collect(Collectors.toMap(method -> method.name.concat(method.desc), method -> {
            ClassInfo.Method realMethod = interceptionMixin.getMethod(method.name, (String)MoreObjects.firstNonNull((Object)InterceptingMixinPlugin.coerceDesc(method), (Object)method.desc));
            if (realMethod == null) {
                throw new IllegalStateException("Cannot find shim method " + method.name + method.desc + " in " + interceptionMixin);
            }
            assert (method.name.equals(realMethod.getOriginalName()));
            assert (Modifier.isStatic(method.access) == realMethod.isStatic());
            return realMethod;
        }));
        if (shims.isEmpty()) {
            return;
        }
        HashMap<Object, Consumer<MethodNode>> surrogates = new HashMap<Object, Consumer<MethodNode>>();
        targetClassName = targetClassName.replace('.', '/');
        Iterator it = targetClass.methods.iterator();
        while (it.hasNext()) {
            Consumer copier;
            Object origin;
            MethodNode method2 = (MethodNode)it.next();
            if (shims.containsKey(method2.name.concat(method2.desc))) {
                it.remove();
                continue;
            }
            AnnotationNode from = Annotations.getInvisible((MethodNode)method2, From.class);
            if (from != null) {
                origin = (String)Annotations.getValue((AnnotationNode)from, (String)"method");
                copier = (Consumer)surrogates.remove(origin);
                if (copier != null) {
                    copier.accept(method2);
                    continue;
                }
                surrogates.put(origin, placatingSurrogate -> {
                    method.instructions = placatingSurrogate.instructions;
                    method.invisibleAnnotations.remove(from);
                });
                continue;
            }
            method2.desc = StringUtils.replace((String)method2.desc, (String)"Lnull;", (String)"Ljava/lang/Object;");
            for (AbstractInsnNode insn : method2.instructions) {
                if (insn.getType() != 5) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                ClassInfo.Method replacedMethod = shims.get(methodInsn.name.concat(methodInsn.desc));
                if (replacedMethod == null || !targetClassName.equals(methodInsn.owner)) continue;
                methodInsn.name = replacedMethod.getName();
                if (methodInsn.desc.equals(replacedMethod.getDesc())) continue;
                Type[] existingArgs = Type.getArgumentTypes((String)methodInsn.desc);
                Type[] replacementArgs = Type.getArgumentTypes((String)replacedMethod.getDesc());
                int end = existingArgs.length;
                for (int index = 0; index < end; ++index) {
                    if (existingArgs[index].equals((Object)replacementArgs[index])) continue;
                    AbstractInsnNode target = insn;
                    for (int i = end - 1; i > index; --i) {
                        while ((target = Objects.requireNonNull(target.getPrevious())).getType() == 15 || target.getType() == 8) {
                        }
                    }
                    if (target.getType() != 2 || target.getOpcode() != existingArgs[index].getOpcode(21)) {
                        throw new UnsupportedOperationException("Unexpectedly complex stack unwinding requested");
                    }
                    method2.instructions.insertBefore(target, (AbstractInsnNode)new TypeInsnNode(192, replacementArgs[index].getInternalName()));
                }
                methodInsn.desc = replacedMethod.getDesc();
            }
            if (Annotations.getInvisible((MethodNode)method2, PlacatingSurrogate.class) == null) continue;
            it.remove();
            origin = method2.name.concat(method2.desc);
            copier = (Consumer)surrogates.remove(origin);
            if (copier != null) {
                copier.accept(method2);
                continue;
            }
            surrogates.put(origin, realSurrogate -> {
                realSurrogate.instructions = method.instructions;
                realSurrogate.invisibleAnnotations.remove(Annotations.getInvisible((MethodNode)realSurrogate, From.class));
            });
        }
    }

    static @interface From {
        public String method();
    }
}

