/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import me.modmuss50.optifabric.mod.ContextualMappingContext;
import me.modmuss50.optifabric.mod.ContextualMappingProvider;
import me.modmuss50.optifabric.shadow.tinyremapper.IMappingProvider;

public class ContextualMapping
implements ContextualMappingContext {
    private final ContextualMappingProvider provider;
    private final BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory;
    private final Map<String, String> classes;
    private final Map<ContextualMappingContext.Member, String> methods;
    private final Map<ContextualMappingContext.Member, String> fields;
    private int contextNeeded;

    public static Builder forMethod(BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory) {
        return new Builder(factory);
    }

    public static Builder forField(BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory) {
        return new Builder(factory);
    }

    private static <T> Map<T, String> convert(Set<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        Object2ObjectArrayMap out = new Object2ObjectArrayMap(list.size());
        for (T object : list) {
            out.put(object, null);
        }
        return out;
    }

    private ContextualMapping(ContextualMappingProvider provider, BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory, Set<String> classes, Set<ContextualMappingContext.Member> methods, Set<ContextualMappingContext.Member> fields) {
        this.provider = provider;
        this.factory = factory;
        this.classes = ContextualMapping.convert(classes);
        this.methods = ContextualMapping.convert(methods);
        this.fields = ContextualMapping.convert(fields);
        this.contextNeeded = classes.size() + methods.size() + fields.size();
    }

    public Set<String> getNeededClasses() {
        return Collections.unmodifiableSet(this.classes.keySet());
    }

    public Set<ContextualMappingContext.Member> getNeededMethods() {
        return Collections.unmodifiableSet(this.methods.keySet());
    }

    public Set<ContextualMappingContext.Member> getNeededFields() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    private <T> void addMapping(Map<T, String> type, T from, String to) {
        if (type.containsKey(from)) {
            type.put(from, to);
            if (--this.contextNeeded <= 0) {
                this.factory.accept(this.provider, this);
            }
        }
    }

    void addClassMapping(String from, String to) {
        if (this.contextNeeded > 0 && !this.classes.isEmpty()) {
            ContextualMapping contextualMapping = this;
            contextualMapping.addMapping(contextualMapping.classes, from, to);
        }
    }

    @Override
    public String unmapClass(String name) {
        return this.provider.getContextTransformer().untransformClass(name);
    }

    @Override
    public String mapClass(String name) {
        return this.classes.get(name);
    }

    void addMethodMapping(IMappingProvider.Member member, String name) {
        if (this.contextNeeded <= 0 || this.methods.isEmpty()) {
            return;
        }
        ContextualMapping contextualMapping = this;
        contextualMapping.addMapping(contextualMapping.methods, new ContextualMappingContext.Member(member), name);
        ContextualMapping contextualMapping2 = this;
        contextualMapping2.addMapping(contextualMapping2.methods, new ContextualMappingContext.Member(member.owner, member.name), name);
    }

    @Override
    public ContextualMappingContext.Member unmapMethod(ContextualMappingContext.Member method) {
        return this.provider.getContextTransformer().untransformMethod(method);
    }

    @Override
    public String mapMethod(ContextualMappingContext.Member method) {
        return this.methods.get(method);
    }

    void addFieldMapping(IMappingProvider.Member member, String name) {
        if (this.contextNeeded <= 0 || this.fields.isEmpty()) {
            return;
        }
        ContextualMapping contextualMapping = this;
        contextualMapping.addMapping(contextualMapping.fields, new ContextualMappingContext.Member(member), name);
        ContextualMapping contextualMapping2 = this;
        contextualMapping2.addMapping(contextualMapping2.fields, new ContextualMappingContext.Member(member.owner, member.name), name);
    }

    @Override
    public ContextualMappingContext.Member unmapField(ContextualMappingContext.Member field) {
        return this.provider.getContextTransformer().untransformField(field);
    }

    @Override
    public String mapField(ContextualMappingContext.Member field) {
        return this.fields.get(field);
    }

    public static class Builder {
        private final BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory;
        private final Set<String> classes = new HashSet<String>();
        private final Set<ContextualMappingContext.Member> methods = new HashSet<ContextualMappingContext.Member>();
        private final Set<ContextualMappingContext.Member> fields = new HashSet<ContextualMappingContext.Member>();

        private Builder(BiConsumer<IMappingProvider.MappingAcceptor, ContextualMappingContext> factory) {
            this.factory = factory;
        }

        public Builder usingClass(String name) {
            this.classes.add(name);
            return this;
        }

        public Builder usingClasses(String ... names) {
            Collections.addAll(this.classes, names);
            return this;
        }

        public Builder usingMethod(ContextualMappingContext.Member method) {
            this.methods.add(method);
            return this;
        }

        public Builder usingMethods(ContextualMappingContext.Member ... methods) {
            Collections.addAll(this.methods, methods);
            return this;
        }

        public Builder usingField(ContextualMappingContext.Member field) {
            this.fields.add(field);
            return this;
        }

        public Builder usingFields(ContextualMappingContext.Member ... fields) {
            Collections.addAll(this.fields, fields);
            return this;
        }

        public ContextualMapping build(ContextualMappingProvider provider) {
            if (this.classes.isEmpty() && this.methods.isEmpty() && this.fields.isEmpty()) {
                throw new IllegalStateException("Tried to make contextual mapping without context");
            }
            return new ContextualMapping(provider, this.factory, this.classes, this.methods, this.fields);
        }
    }
}

