/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.modmuss50.optifabric.mod.ContextualMapping;
import me.modmuss50.optifabric.mod.ContextualMappingContext;
import me.modmuss50.optifabric.shadow.tinyremapper.IMappingProvider;

public class ContextualMappingProvider
implements IMappingProvider.MappingAcceptor {
    private final IMappingProvider.MappingAcceptor parent;
    private final List<ContextualMapping> extraMappings = new ArrayList<ContextualMapping>();
    private ContextTransformer transformer = new ContextTransformer(){

        @Override
        public String transformClass(String name) {
            return name;
        }

        @Override
        public String untransformClass(String name) {
            return name;
        }

        @Override
        public IMappingProvider.Member transformMethod(IMappingProvider.Member method) {
            return method;
        }

        @Override
        public ContextualMappingContext.Member untransformMethod(ContextualMappingContext.Member method) {
            return method;
        }

        @Override
        public IMappingProvider.Member transformField(IMappingProvider.Member field) {
            return field;
        }

        @Override
        public ContextualMappingContext.Member untransformField(ContextualMappingContext.Member field) {
            return field;
        }
    };

    public ContextualMappingProvider(IMappingProvider.MappingAcceptor parent) {
        this.parent = parent;
    }

    public ContextualMappingProvider add(ContextualMapping.Builder mapping) {
        this.extraMappings.add(mapping.build(this));
        return this;
    }

    public void setContextTransformer(Function<List<ContextualMapping>, ContextTransformer> factory) {
        this.transformer = Objects.requireNonNull(factory.apply(Collections.unmodifiableList(this.extraMappings)), "Transformer must not be null");
    }

    public ContextTransformer getContextTransformer() {
        return this.transformer;
    }

    public void acceptClass(String srcName, String dstName) {
        this.parent.acceptClass(srcName, dstName);
        srcName = this.transformer.transformClass(srcName);
        Iterator<ContextualMapping> iterator = this.extraMappings.iterator();
        while (iterator.hasNext()) {
            iterator.next().addClassMapping(srcName, dstName);
        }
    }

    public void acceptMethod(IMappingProvider.Member method, String dstName) {
        this.parent.acceptMethod(method, dstName);
        method = this.transformer.transformMethod(method);
        Iterator<ContextualMapping> iterator = this.extraMappings.iterator();
        while (iterator.hasNext()) {
            iterator.next().addMethodMapping(method, dstName);
        }
    }

    public void acceptMethodArg(IMappingProvider.Member method, int lvIndex, String dstName) {
        this.parent.acceptMethodArg(method, lvIndex, dstName);
    }

    public void acceptMethodVar(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String dstName) {
        this.parent.acceptMethodVar(method, lvIndex, startOpIdx, asmIndex, dstName);
    }

    public void acceptField(IMappingProvider.Member field, String dstName) {
        this.parent.acceptField(field, dstName);
        field = this.transformer.transformField(field);
        Iterator<ContextualMapping> iterator = this.extraMappings.iterator();
        while (iterator.hasNext()) {
            iterator.next().addFieldMapping(field, dstName);
        }
    }

    public static interface ContextTransformer {
        public String transformClass(String var1);

        public String untransformClass(String var1);

        public IMappingProvider.Member transformMethod(IMappingProvider.Member var1);

        public ContextualMappingContext.Member untransformMethod(ContextualMappingContext.Member var1);

        public IMappingProvider.Member transformField(IMappingProvider.Member var1);

        public ContextualMappingContext.Member untransformField(ContextualMappingContext.Member var1);
    }
}

