/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.modmuss50.optifabric.mod.ContextualMapping;
import me.modmuss50.optifabric.mod.ContextualMappingContext;
import me.modmuss50.optifabric.mod.ContextualMappingProvider;
import me.modmuss50.optifabric.mod.OptifineSetup;
import me.modmuss50.optifabric.shadow.tinyremapper.IMappingProvider;
import me.modmuss50.optifabric.shadow.tinyremapper.TinyUtils;
import org.objectweb.asm.commons.Remapper;

public class IntermediaryContextTransformer
implements ContextualMappingProvider.ContextTransformer {
    private final BiMap<String, String> classes = HashBiMap.create((int)8192);
    private final Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> backwardMethods = new HashMap<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>>();
    private final Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> backwardFields = new HashMap<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>>();
    private final Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> forwardMethods = new HashMap<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>>();
    private final Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> forwardFields = new HashMap<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntermediaryContextTransformer(String to, List<ContextualMapping> mappings) {
        for (ContextualMapping mapping : mappings) {
            for (ContextualMappingContext.Member method : mapping.getNeededMethods()) {
                this.backwardMethods.computeIfAbsent(method.owner, k -> new HashMap(4)).put(method, null);
            }
            for (ContextualMappingContext.Member field : mapping.getNeededFields()) {
                this.backwardFields.computeIfAbsent(field.owner, k -> new HashMap(4)).put(field, null);
            }
        }
        try {
            BufferedReader in;
            block14: {
                in = new BufferedReader(new InputStreamReader(OptifineSetup.class.getResourceAsStream("/mappings/mappings.tiny"), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    TinyUtils.createTinyMappingProvider((BufferedReader)in, (String)"intermediary", (String)to).load((IMappingProvider.MappingAcceptor)new MappingRemapper());
                    if (throwable == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable4 = throwable2;
                        throwable = throwable2;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            in.close();
                            throw throwable5;
                        }
                        try {
                            in.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                }
                try {
                    in.close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            in.close();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read Intermediary -> " + to + " mappings", e);
        }
    }

    @Override
    public String transformClass(String name) {
        String string = name;
        return (String)this.classes.getOrDefault((Object)string, (Object)string);
    }

    private void remapMemberForwards(Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> map, IMappingProvider.Member member) {
        Map<ContextualMappingContext.Member, ContextualMappingContext.Member> memberMap = map.get(member.owner);
        if (memberMap == null) {
            return;
        }
        ContextualMappingContext.Member remap = memberMap.get(new ContextualMappingContext.Member(member));
        if (remap == null) {
            return;
        }
        member.owner = remap.owner;
        member.name = remap.name;
        member.desc = remap.desc;
    }

    @Override
    public IMappingProvider.Member transformMethod(IMappingProvider.Member method) {
        if (!this.forwardMethods.isEmpty()) {
            IntermediaryContextTransformer intermediaryContextTransformer = this;
            intermediaryContextTransformer.remapMemberForwards(intermediaryContextTransformer.forwardMethods, method);
        }
        return method;
    }

    @Override
    public IMappingProvider.Member transformField(IMappingProvider.Member field) {
        if (!this.forwardFields.isEmpty()) {
            IntermediaryContextTransformer intermediaryContextTransformer = this;
            intermediaryContextTransformer.remapMemberForwards(intermediaryContextTransformer.forwardFields, field);
        }
        return field;
    }

    @Override
    public String untransformClass(String name) {
        String string = name;
        return (String)this.classes.inverse().getOrDefault((Object)string, (Object)string);
    }

    private ContextualMappingContext.Member remapMemberBackwards(Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> map, ContextualMappingContext.Member member) {
        Map<ContextualMappingContext.Member, ContextualMappingContext.Member> memberMap = map.get(member.owner);
        if (memberMap == null) {
            return member;
        }
        ContextualMappingContext.Member member2 = member;
        return memberMap.getOrDefault(member2, member2);
    }

    @Override
    public ContextualMappingContext.Member untransformMethod(ContextualMappingContext.Member method) {
        IntermediaryContextTransformer intermediaryContextTransformer = this;
        return intermediaryContextTransformer.remapMemberBackwards(intermediaryContextTransformer.backwardMethods, method);
    }

    @Override
    public ContextualMappingContext.Member untransformField(ContextualMappingContext.Member field) {
        IntermediaryContextTransformer intermediaryContextTransformer = this;
        return intermediaryContextTransformer.remapMemberBackwards(intermediaryContextTransformer.backwardFields, field);
    }

    class MappingRemapper
    extends Remapper
    implements IMappingProvider.MappingAcceptor {
        private MappingRemapper() {
        }

        private void noteMember(Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> backward, IMappingProvider.Member member, String name, Map<String, Map<ContextualMappingContext.Member, ContextualMappingContext.Member>> forward) {
            Map<ContextualMappingContext.Member, ContextualMappingContext.Member> memberMap = backward.get(member.owner);
            if (memberMap == null) {
                return;
            }
            ContextualMappingContext.Member key = new ContextualMappingContext.Member(member);
            boolean hasKey = memberMap.containsKey(key);
            ContextualMappingContext.Member naiveKey = new ContextualMappingContext.Member(member.owner, member.name);
            boolean hasNaiveKey = memberMap.containsKey(naiveKey);
            if (!hasKey && !hasNaiveKey) {
                return;
            }
            ContextualMappingContext.Member mappedKey = new ContextualMappingContext.Member(this.map(member.owner), name, this.mapDesc(member.desc));
            forward.computeIfAbsent(mappedKey.owner, k -> new HashMap(4)).put(mappedKey, key);
            if (hasKey) {
                memberMap.put(key, mappedKey);
            }
            if (hasNaiveKey) {
                memberMap.put(naiveKey, mappedKey);
            }
        }

        public void acceptClass(String srcName, String dstName) {
            IntermediaryContextTransformer.this.classes.put((Object)dstName, (Object)srcName);
        }

        public String map(String internalName) {
            String string = internalName;
            return (String)IntermediaryContextTransformer.this.classes.inverse().getOrDefault((Object)string, (Object)string);
        }

        public void acceptMethod(IMappingProvider.Member method, String dstName) {
            if (!IntermediaryContextTransformer.this.backwardMethods.isEmpty()) {
                MappingRemapper mappingRemapper = this;
                mappingRemapper.noteMember(mappingRemapper.IntermediaryContextTransformer.this.backwardMethods, method, dstName, IntermediaryContextTransformer.this.forwardMethods);
            }
        }

        public void acceptMethodArg(IMappingProvider.Member method, int lvIndex, String dstName) {
        }

        public void acceptMethodVar(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String dstName) {
        }

        public void acceptField(IMappingProvider.Member field, String dstName) {
            if (!IntermediaryContextTransformer.this.backwardFields.isEmpty()) {
                MappingRemapper mappingRemapper = this;
                mappingRemapper.noteMember(mappingRemapper.IntermediaryContextTransformer.this.backwardFields, field, dstName, IntermediaryContextTransformer.this.forwardFields);
            }
        }
    }
}

