/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import me.modmuss50.optifabric.mod.OptifabricSetup;
import org.apache.commons.lang3.StringUtils;

public enum OptifineResources {
    INSTANCE;

    private final ZipFile zip;

    private OptifineResources() {
        try {
            this.zip = new ZipFile(OptifabricSetup.optifineRuntimeJar);
            return;
        }
        catch (ZipError | ZipException e) {
            throw new RuntimeException("Error opening Optifine jar, probably corrupt?", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error opening Optifine jar", e);
        }
    }

    private ZipEntry getEntry(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.zip.getEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        }
        return null;
    }

    public final boolean hasResource(String path) {
        return this.getEntry(path) != null;
    }

    public final InputStream getResource(String path) throws IOException {
        ZipEntry entry = this.getEntry(path);
        if (entry != null) {
            return this.zip.getInputStream(entry);
        }
        return null;
    }
}

