/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import me.modmuss50.optifabric.mod.ContextualMapping;
import me.modmuss50.optifabric.mod.ContextualMappingContext;
import me.modmuss50.optifabric.mod.ContextualMappingProvider;
import me.modmuss50.optifabric.mod.IntermediaryContextTransformer;
import me.modmuss50.optifabric.mod.OptifabricError;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.mod.Preloader;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.LambdaRebuilder;
import me.modmuss50.optifabric.shadow.tinyremapper.IMappingProvider;
import me.modmuss50.optifabric.shadow.tinyremapper.InputTag;
import me.modmuss50.optifabric.shadow.tinyremapper.NonClassCopyMode;
import me.modmuss50.optifabric.shadow.tinyremapper.OutputConsumerPath;
import me.modmuss50.optifabric.shadow.tinyremapper.TinyRemapper;
import me.modmuss50.optifabric.shadow.tinyremapper.TinyUtils;
import me.modmuss50.optifabric.util.ASMUtils;
import me.modmuss50.optifabric.util.ZipUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.RecordComponentNode;

public class OptifineSetup {
    public static Pair<File, ClassCache> getRuntime() throws IOException {
        File[] finalRemappedJar;
        Consumer<ZipUtils.ZipVisitor> jarFinaliser;
        byte[] modHash;
        File workingDir = new File(FabricLoader.getInstance().getGameDirectory(), ".optifine");
        if (!workingDir.exists()) {
            FileUtils.forceMkdir((File)workingDir);
        }
        File optifineModJar = OptifineVersion.findOptifineJar();
        Throwable throwable = null;
        try (FileInputStream in = new FileInputStream(optifineModJar);){
            modHash = DigestUtils.md5((InputStream)in);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        File versionDir = new File(workingDir, OptifineVersion.version);
        if (!versionDir.exists()) {
            FileUtils.forceMkdir((File)versionDir);
        }
        Object remappedJar = new File(versionDir, "Optifine-mapped.jar");
        File optifinePatches = new File(versionDir, "Optifine.classes.gz");
        if (remappedJar.exists() && optifinePatches.exists()) {
            ClassCache classCache = ClassCache.read(optifinePatches);
            if (Arrays.equals(classCache.getHash(), modHash)) {
                System.out.println("Found existing patched optifine jar, using that");
                if (classCache.isConverted()) {
                    classCache.save(optifinePatches);
                }
                return Pair.of((Object)remappedJar, (Object)classCache);
            }
            System.out.println("Class cache is from a different optifine jar, deleting and re-generating");
        } else {
            System.out.println("Setting up optifine for the first time, this may take a few seconds.");
        }
        Path minecraftJar = OptifineSetup.getMinecraftJar();
        File workDir = Files.createTempDirectory("optifabric", new FileAttribute[0]).toFile();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            File optifineMod;
            block29: {
                optifineMod = new File(workDir, "Optifine-mod.jar");
                if (!optifineMod.exists() || !ZipUtils.isValid(optifineMod)) {
                    for (int attempt = 1; attempt <= 3; ++attempt) {
                        OptifineSetup.runInstaller(optifineModJar, optifineMod, minecraftJar.toFile());
                        if (!ZipUtils.isValid(optifineMod)) {
                            optifineMod.delete();
                            continue;
                        }
                        break block29;
                    }
                    OptifineVersion.jarType = OptifineVersion.JarType.CORRUPT_ZIP;
                    OptifabricError.setError("OptiFine installer keeps producing corrupt jars!\nRan: %s 3 times\nMinecraft jar: %s", optifineModJar, minecraftJar);
                    throw new ZipException("Ran OptiFine installer (" + optifineModJar + ") three times without a valid jar produced");
                }
            }
            optifineModJar = optifineMod;
        }
        File jarOfTheFree = new File(workDir, "Optifine-jarofthefree.jar");
        final LambdaRebuilder rebuilder = new LambdaRebuilder(minecraftJar.toFile());
        System.out.println("De-Volderfiying jar");
        ZipUtils.transform(optifineModJar, new ZipUtils.ZipTransformer(){
            private final boolean correctRecords = FabricLoader.getInstance().isDevelopmentEnvironment();

            @Override
            public final String mapName(ZipEntry entry) {
                String out = entry.getName();
                if (out.startsWith("notch/")) {
                    return out.substring(6);
                }
                return out;
            }

            @Override
            public final InputStream apply(ZipFile zip, ZipEntry entry) throws IOException {
                String name = entry.getName();
                if (!name.startsWith("srg/")) {
                    if (!(!name.endsWith(".class") || name.startsWith("net/") || name.startsWith("notch/net/") || name.startsWith("optifine/") || name.startsWith("javax/"))) {
                        ClassNode node = ASMUtils.readClass(zip, entry);
                        rebuilder.findLambdas(node);
                        if (this.correctRecords && (node.access & 0x10000) != 0) {
                            assert (node.recordComponents != null) : "Record with no components: " + node.name;
                            Map descToNames = node.fields.stream().filter(field -> !Modifier.isStatic(field.access)).collect(Collectors.groupingBy(field -> field.desc, Collectors.mapping(field -> FabricLoader.getInstance().getMappingResolver().mapFieldName("official", node.name, field.name, field.desc), Collectors.toSet())));
                            for (RecordComponentNode component : node.recordComponents) {
                                Set existingNames = descToNames.get(component.descriptor);
                                if (existingNames == null || !existingNames.contains(component.name)) continue;
                                String desc = "()".concat(component.descriptor);
                                node.methods.removeIf(method -> method.name.equals(component.name) && desc.equals(method.desc));
                            }
                        }
                        ClassWriter writer = new ClassWriter(0);
                        node.accept((ClassVisitor)writer);
                        return new ByteArrayInputStream(writer.toByteArray());
                    }
                    return zip.getInputStream(entry);
                }
                return null;
            }
        }, jarOfTheFree);
        rebuilder.close();
        String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
        System.out.println("Remapping optifine from official to ".concat(String.valueOf(namespace)));
        File completeJar = new File(workDir, "Optifine-remapped.jar");
        OptifineSetup.remapOptifine(jarOfTheFree, OptifineSetup.getLibs(minecraftJar), completeJar, OptifineSetup.createMappings("official", namespace, rebuilder));
        Iterator iterator = FabricLoader.getInstance().getEntrypoints("optifabric:transformer", UnaryOperator.class).iterator();
        while (iterator.hasNext()) {
            completeJar = (File)((UnaryOperator)iterator.next()).apply(completeJar);
            if (completeJar != null && completeJar.canRead()) continue;
            throw new IllegalStateException("Jar transformer returned invalid jar: ".concat(String.valueOf(completeJar)));
        }
        File completedJar = completeJar;
        if (remappedJar.exists() && !remappedJar.delete()) {
            System.err.println("Failed to clear " + remappedJar + ", is another instance of the game running?");
            remappedJar = completedJar;
            jarFinaliser = visitor -> ZipUtils.filterInPlace(completedJar, visitor);
        } else {
            finalRemappedJar = remappedJar;
            jarFinaliser = arg_0 -> OptifineSetup.lambda$getRuntime$1(completedJar, (File)finalRemappedJar, arg_0);
        }
        if (optifinePatches.exists() && !optifinePatches.delete()) {
            System.err.println("Failed to clear " + optifinePatches + ", is another instance of the game running?");
            optifinePatches = new File(workDir, "Optifine.classes.gz");
        }
        workDir.deleteOnExit();
        finalRemappedJar = workDir.listFiles();
        int n = finalRemappedJar.length;
        for (int i = 0; i < n; ++i) {
            finalRemappedJar[i].deleteOnExit();
        }
        boolean extract = Boolean.getBoolean("optifabric.extract");
        if (extract) {
            System.out.println("Extracting optifine classes");
            File optifineClasses = new File(versionDir, "optifine-classes");
            if (optifineClasses.exists()) {
                FileUtils.deleteDirectory((File)optifineClasses);
            }
            ZipUtils.extract(completedJar, optifineClasses);
        }
        return Pair.of((Object)remappedJar, (Object)OptifineSetup.generateClassCache(jarFinaliser, optifinePatches, modHash, extract));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runInstaller(File installer, File output, File minecraftJar) throws IOException {
        System.out.println("Running optifine patcher");
        try {
            URLClassLoader classLoader;
            block11: {
                classLoader = new URLClassLoader(new URL[]{installer.toURI().toURL()}, OptifineSetup.class.getClassLoader());
                Throwable throwable = null;
                try {
                    classLoader.loadClass("optifine.Patcher").getDeclaredMethod("process", File.class, File.class, File.class).invoke(null, minecraftJar, installer, output);
                    if (throwable == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable4 = throwable2;
                        throwable = throwable2;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            classLoader.close();
                            throw throwable5;
                        }
                        try {
                            classLoader.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                }
                try {
                    classLoader.close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            classLoader.close();
            return;
        }
        catch (ReflectiveOperationException | MalformedURLException e) {
            throw new RuntimeException("Error running OptiFine patcher at " + installer + " on " + minecraftJar, e);
        }
    }

    private static void remapOptifine(File input, Path[] libraries, File output, IMappingProvider mappings) throws IOException {
        OptifineSetup.remapOptifine(input.toPath(), libraries, output.toPath(), mappings);
    }

    private static void remapOptifine(Path input, Path[] libraries, Path output, IMappingProvider mappings) throws IOException {
        boolean bl;
        Files.deleteIfExists(output);
        Preloader.preloadTinyRemapper();
        IMappingProvider iMappingProvider = mappings;
        TinyRemapper.Builder builder = TinyRemapper.newRemapper();
        builder.mappingProviders.add(iMappingProvider);
        builder.skipLocalMapping = true;
        v0.renameInvalidLocals = bl = FabricLoader.getInstance().isDevelopmentEnvironment();
        builder.rebuildSourceFilenames = true;
        TinyRemapper remapper = new TinyRemapper((Collection)builder.mappingProviders, builder.forcePropagation, builder.knownIndyBsm, builder.propagateBridges, builder.propagateRecordComponents, builder.rebuildSourceFilenames, builder.skipLocalMapping, builder.renameInvalidLocals, builder.invalidLvNamePattern, builder.analyzeVisitors, builder.stateProcessors, builder.preApplyVisitors, builder.postApplyVisitors, builder.extraRemapper);
        try {
            builder = new OutputConsumerPath.Builder(output);
            new OutputConsumerPath.Builder(output).assumeArchive = Boolean.TRUE;
            bl = builder.assumeArchive == null || Files.exists(builder.destination, new LinkOption[0]) ? OutputConsumerPath.access$000((Path)builder.destination) : builder.assumeArchive;
            Throwable throwable = null;
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath(builder.destination, bl, builder.classNameFilter);){
                Path[] pathArray;
                CompletableFuture completableFuture = null;
                Path[] pathArray2 = NonClassCopyMode.UNCHANGED;
                List list = pathArray2.remappers;
                CompletableFuture completableFuture2 = completableFuture;
                Path path = input;
                OutputConsumerPath outputConsumerPath = outputConsumer;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    outputConsumerPath.addNonClassFiles(path, completableFuture2, false, list);
                } else if (Files.exists(path, new LinkOption[0])) {
                    if (!path.getFileName().toString().endsWith(".class")) {
                        outputConsumerPath.addNonClassFiles(FileSystems.newFileSystem(path, (ClassLoader)null).getPath("/", new String[0]), completableFuture2, true, list);
                    }
                } else {
                    throw new FileNotFoundException("file " + path + " doesn't exist");
                }
                pathArray2 = pathArray = new Path[]{input};
                InputTag inputTag = null;
                Object object = remapper;
                completableFuture = object.read(pathArray2, true, inputTag);
                if (!completableFuture.isDone()) {
                    ((TinyRemapper)object).pendingReads.add(completableFuture);
                } else {
                    completableFuture.join();
                }
                pathArray = libraries;
                builder = remapper;
                object = builder.read(pathArray, false, null);
                if (!((CompletableFuture)object).isDone()) {
                    builder.pendingReads.add(object);
                } else {
                    ((CompletableFuture)object).join();
                }
                remapper.apply((BiConsumer)outputConsumer, (InputTag[])null);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap jar", e);
        }
        finally {
            remapper.finish();
        }
    }

    private static IMappingProvider createMappings(final String from, final String to, final IMappingProvider extra) {
        return new IMappingProvider(){

            private void standardExtraMappings(ContextualMappingProvider mapper) {
                String rebuildTask = "net/minecraft/class_846$class_851$class_4578";
                String builtChunk = "net/minecraft/class_846$class_851";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(rebuildTask), "this$1", "L" + context.unmapClass(builtChunk) + ';'), "field_20839")).usingClasses(rebuildTask, builtChunk));
                String particleManager = "net/minecraft/class_702";
                ContextualMappingContext.Member factories = new ContextualMappingContext.Member(particleManager, "field_3835");
                mapper.add(ContextualMapping.forField((out, context) -> {
                    ContextualMappingContext.Member fromFactories = context.unmapField(factories);
                    out.acceptField(new IMappingProvider.Member(context.unmapClass(particleManager), fromFactories.name, "Ljava/util/Map;"), context.mapField(factories));
                }).usingClass(particleManager).usingField(factories));
                String clientEntityHandler = "net/minecraft/class_638$class_5612";
                String clientWorld = "net/minecraft/class_638";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(clientEntityHandler), "this$0", "L" + context.unmapClass(clientWorld) + ';'), "field_27735")).usingClasses(clientEntityHandler, clientWorld));
                String bakerImpl = "net/minecraft/class_1088$class_7778";
                String modelLoader = "net/minecraft/class_1088";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(bakerImpl), "this$0", "L" + context.unmapClass(modelLoader) + ';'), "field_40571")).usingClasses(bakerImpl, modelLoader));
            }

            private void devExtraMappings(ContextualMappingProvider mapper) {
                String option = "net/minecraft/class_316";
                String cyclingOption = "net/minecraft/class_4064";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(option), "CLOUDS", "L" + context.unmapClass(cyclingOption) + ';'), "CLOUDS_OF")).usingClasses(option, cyclingOption));
                String worldRenderer = "net/minecraft/class_761";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(worldRenderer), "renderDistance", "I"), "renderDistance_OF")).usingClass(worldRenderer));
                String threadExecutor = "net/minecraft/class_1255";
                mapper.add(ContextualMapping.forMethod((out, context) -> out.acceptMethod(new IMappingProvider.Member(context.unmapClass(threadExecutor), "getTaskCount", "()I"), "getTaskCount_OF")).usingClass(threadExecutor));
                String vertexBuffer = "net/minecraft/class_291";
                mapper.add(ContextualMapping.forField((out, context) -> out.acceptField(new IMappingProvider.Member(context.unmapClass(vertexBuffer), "vertexCount", "I"), "vertexCount_OF")).usingClass(vertexBuffer));
                String modelPart = "net/minecraft/class_630";
                mapper.add(ContextualMapping.forMethod((out, context) -> {
                    String modelPartName = context.unmapClass(modelPart);
                    out.acceptMethod(new IMappingProvider.Member(modelPartName, "getChild", "(Ljava/lang/String;)L" + modelPartName + ';'), "getChild_OF");
                }).usingClass(modelPart));
            }

            public final void load(IMappingProvider.MappingAcceptor parent) {
                ContextualMappingProvider out = new ContextualMappingProvider(parent);
                this.standardExtraMappings(out);
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    this.devExtraMappings(out);
                }
                out.setContextTransformer(mappings -> new IntermediaryContextTransformer(from, (List<ContextualMapping>)mappings));
                try {
                    Throwable throwable = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(OptifineSetup.class.getResourceAsStream("/mappings/mappings.tiny"), StandardCharsets.UTF_8));){
                        TinyUtils.createTinyMappingProvider((BufferedReader)in, (String)from, (String)to).load((IMappingProvider.MappingAcceptor)out);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read " + from + " -> " + to + " mappings", e);
                }
                extra.load((IMappingProvider.MappingAcceptor)out);
            }
        };
    }

    private static Path[] getLibs(Path minecraftJar) {
        Object[] libs;
        block2: {
            libs = (Path[])FabricLauncherBase.getLauncher().getLoadTimeDependencies().stream().map(url -> {
                try {
                    return Paths.get(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Failed to convert " + url + " to path", e);
                }
            }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                Path launchJar = OptifineSetup.getLaunchMinecraftJar();
                int end = libs.length;
                for (int i = 0; i < end; ++i) {
                    Path lib = libs[i];
                    if (!launchJar.equals(lib)) continue;
                    libs[i] = minecraftJar;
                    break block2;
                }
                throw new IllegalStateException("Unable to find Minecraft jar (at " + launchJar + ") in classpath: " + Arrays.toString(libs));
            }
        }
        return libs;
    }

    private static Path getMinecraftJar() {
        String givenJar = System.getProperty("optifabric.mc-jar");
        if (givenJar != null) {
            File givenJarFile = new File(givenJar);
            if (givenJarFile.exists()) {
                return givenJarFile.toPath();
            }
            System.err.println("Supplied Minecraft jar at " + givenJar + " doesn't exist, falling back");
        }
        Path minecraftJar = OptifineSetup.getLaunchMinecraftJar();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path officialNames = minecraftJar.resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (Files.notExists(officialNames, new LinkOption[0])) {
                Path parent = minecraftJar.getParent().resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
                if (Files.notExists(parent, new LinkOption[0])) {
                    Path alternativeParent = parent.resolveSibling("minecraft-client.jar");
                    if (Files.notExists(alternativeParent, new LinkOption[0])) {
                        throw new AssertionError((Object)("Unable to find Minecraft dev jar! Tried " + officialNames + ", " + parent + " and " + alternativeParent + "\nPlease supply it explicitly with -Doptifabric.mc-jar"));
                    }
                    parent = alternativeParent;
                }
                officialNames = parent;
            }
            minecraftJar = officialNames;
        }
        return minecraftJar;
    }

    private static Path getLaunchMinecraftJar() {
        try {
            return (Path)FabricLoader.getInstance().getObjectShare().get("fabric-loader:inputGameJar");
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            Path out;
            int split;
            URI uri = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new IllegalStateException("No Minecraft?"))).getRootPath().toUri();
            assert ("jar".equals(uri.getScheme()));
            String path = uri.getSchemeSpecificPart();
            if (path.substring(0, split = path.lastIndexOf("!/")).indexOf(32) > 0 && path.startsWith("file:///") && Files.exists(out = Paths.get(path.substring(8, split), new String[0]), new LinkOption[0])) {
                return out;
            }
            try {
                return Paths.get(new URI(path.substring(0, split)));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to find Minecraft jar from " + uri + " (calculated " + path.substring(0, split) + ')', e);
            }
        }
    }

    private static ClassCache generateClassCache(Consumer<ZipUtils.ZipVisitor> from, File to, byte[] hash, boolean extractClasses) throws IOException {
        File classesDir = new File(to.getParent(), "classes");
        if (extractClasses) {
            if (classesDir.exists()) {
                FileUtils.cleanDirectory((File)classesDir);
            } else {
                FileUtils.forceMkdir((File)classesDir);
            }
        }
        ClassCache classCache = new ClassCache(hash);
        from.accept((jarFile, entry) -> {
            String name = entry.getName();
            if ((name.startsWith("net/minecraft/") || name.startsWith("com/mojang/")) && name.endsWith(".class")) {
                Throwable throwable = null;
                try (InputStream in = jarFile.getInputStream(entry);){
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    classCache.addClass(name.substring(0, name.length() - 6), bytes);
                    if (extractClasses) {
                        FileUtils.writeByteArrayToFile((File)new File(classesDir, name), (byte[])bytes);
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                return false;
            }
            return true;
        });
        System.out.println("Found " + classCache.getClasses().size() + " patched classes");
        classCache.save(to);
        return classCache;
    }

    private static /* synthetic */ void lambda$getRuntime$1(File completedJar, File finalRemappedJar, ZipUtils.ZipVisitor visitor) {
        ZipUtils.filter(completedJar, visitor, finalRemappedJar);
    }
}

