/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.apache.commons.lang3.Validate;

public class ClassCache {
    private final byte[] hash;
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private boolean converted;

    public ClassCache(byte[] hash) {
        this.hash = hash;
    }

    public void addClass(String name, byte[] bytes) {
        if (this.classes.containsKey(name)) {
            throw new IllegalArgumentException(name + " is already in ClassCache");
        }
        this.classes.put(name, (byte[])Validate.notNull((Object)bytes, (String)"Passed null bytes for %s", (Object[])new Object[]{name}));
    }

    public Set<String> getClasses() {
        return this.classes.keySet();
    }

    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    public byte[] popClass(String name) {
        return this.classes.remove(name);
    }

    public byte[] getHash() {
        return this.hash;
    }

    private long calculateCRC() {
        CRC32 crc = new CRC32();
        crc.update(this.hash);
        for (byte[] clazz : this.classes.values()) {
            crc.update(clazz);
        }
        return crc.getValue();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassCache read(File input) throws IOException {
        try {
            ClassCache classCache;
            Throwable throwable;
            DataInputStream dis;
            block20: {
                ClassCache classCache2;
                block21: {
                    block18: {
                        ClassCache classCache3;
                        block19: {
                            dis = new DataInputStream(new GZIPInputStream(new FileInputStream(input)));
                            throwable = null;
                            if (dis.readChar() == 'E') break block18;
                            classCache3 = new ClassCache(null);
                            if (throwable == null) break block19;
                            try {
                                dis.close();
                                return classCache3;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return classCache3;
                            }
                        }
                        dis.close();
                        return classCache3;
                    }
                    long expectedCRC = dis.readLong();
                    byte[] hash = new byte[dis.readInt()];
                    dis.readFully(hash);
                    classCache = new ClassCache(hash);
                    int count = dis.readInt();
                    for (int i = 0; i < count; ++i) {
                        byte[] nameBytes = new byte[dis.readInt()];
                        dis.readFully(nameBytes);
                        String name = new String(nameBytes, StandardCharsets.UTF_8);
                        byte[] bytes = new byte[dis.readInt()];
                        dis.readFully(bytes);
                        classCache.classes.put(name, bytes);
                    }
                    if (classCache.calculateCRC() == expectedCRC) break block20;
                    classCache2 = new ClassCache(null);
                    if (throwable == null) break block21;
                    try {
                        dis.close();
                        return classCache2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return classCache2;
                    }
                }
                dis.close();
                return classCache2;
            }
            ClassCache classCache4 = classCache;
            if (throwable == null) {
                dis.close();
                return classCache4;
            }
            try {
                dis.close();
                return classCache4;
            }
            catch (Throwable throwable4) {
                throwable.addSuppressed(throwable4);
                return classCache4;
            }
            catch (Throwable throwable5) {
                try {
                    Throwable throwable6 = throwable5;
                    throwable = throwable5;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        dis.close();
                        throw throwable7;
                    }
                    try {
                        dis.close();
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                        throw throwable7;
                    }
                }
            }
        }
        catch (ZipException zipException) {
            return new ClassCache(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(File output) throws IOException {
        DataOutputStream dos;
        block11: {
            if (output.exists()) {
                output.delete();
            }
            dos = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(output)));
            Throwable throwable = null;
            try {
                dos.writeChar(69);
                dos.writeLong(this.calculateCRC());
                dos.writeInt(this.hash.length);
                dos.write(this.hash);
                dos.writeInt(this.classes.size());
                for (Map.Entry<String, byte[]> clazz : this.classes.entrySet()) {
                    byte[] nameBytes = clazz.getKey().getBytes(StandardCharsets.UTF_8);
                    byte[] bytes = clazz.getValue();
                    dos.writeInt(nameBytes.length);
                    dos.write(nameBytes);
                    dos.writeInt(bytes.length);
                    dos.write(bytes);
                }
                if (throwable == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        dos.close();
                        throw throwable5;
                    }
                    try {
                        dos.close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                dos.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        dos.close();
    }

    public boolean isConverted() {
        return this.converted;
    }
}

