/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class KeyboardFix
implements ClassFixer {
    private final String screenClass = RemappingUtils.getClassName("class_437");
    private final Set<String> revertMethods = ImmutableSet.of((Object)RemappingUtils.getMethodName("class_309", "method_1466", "(JIIII)V"), (Object)RemappingUtils.getMethodName("class_309", "method_1454", "(IL" + this.screenClass + ";[ZIII)V"), (Object)RemappingUtils.getMethodName("class_309", "method_1458", "(L" + this.screenClass + ";II)V"), (Object)RemappingUtils.getMethodName("class_309", "method_1473", "(L" + this.screenClass + ";CI)V"), (Object)RemappingUtils.getMethodName("class_309", "method_1463", "(Lnet/minecraft/class_2561)V"), (Object)RemappingUtils.getMethodName("class_309", "method_1464", "(Lnet/minecraft/class_2561)V"), (Object[])new String[0]);

    @Override
    public void fix(ClassNode optifine, ClassNode minecraft) {
        Validate.noNullElements(this.revertMethods, (String)"Failed to remap Keyboard method name %d", (Object[])new Object[0]);
        optifine.methods.removeIf(method -> this.revertMethods.contains(method.name));
        List lambdas = minecraft.methods.stream().filter(method -> this.revertMethods.contains(method.name)).collect(Collectors.toList());
        if (lambdas.size() != this.revertMethods.size()) {
            Set foundLambdas = lambdas.stream().map(method -> method.name).collect(Collectors.toSet());
            throw new RuntimeException(this.revertMethods.stream().filter(name -> !foundLambdas.contains(name)).collect(Collectors.joining(", ", "Failed to find Keyboard methods: ", "")));
        }
        optifine.methods.addAll(lambdas);
        String targetDescC = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_437;CI)V");
        String targetDescI = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_437;II)V");
        for (MethodNode method2 : optifine.methods) {
            if ((method2.access | 8 | 0x1000) == method2.access && (method2.desc.equals(targetDescC) || method2.desc.equals(targetDescI))) {
                method2.desc = method2.desc.replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";");
                for (AbstractInsnNode ain : method2.instructions.toArray()) {
                    if (ain.getOpcode() != 25 || ((VarInsnNode)ain).var != 0) continue;
                    method2.instructions.insert(ain, (AbstractInsnNode)new TypeInsnNode(192, RemappingUtils.getClassName("class_437")));
                }
                continue;
            }
            for (AbstractInsnNode ain : method2.instructions) {
                Handle handle;
                if (ain.getOpcode() != 186) continue;
                InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)ain;
                if (idin.bsmArgs.length != 3 || !(idin.bsmArgs[1] instanceof Handle) || (handle = (Handle)idin.bsmArgs[1]).getTag() != 6 || !handle.getOwner().equals(RemappingUtils.getClassName("class_309")) || !handle.getDesc().equals(targetDescC) && !handle.getDesc().equals(targetDescI)) continue;
                idin.desc = idin.desc.replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";");
                idin.bsmArgs[1] = new Handle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc().replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";"), handle.isInterface());
            }
        }
    }
}

