/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ASMUtils {
    public static ClassNode readClass(byte[] bytes) {
        return ASMUtils.readClass(new ClassReader(Objects.requireNonNull(bytes, "Cannot read null class bytes")));
    }

    public static ClassNode readClass(File file) throws IOException {
        Throwable throwable = null;
        try (FileInputStream in = new FileInputStream(Objects.requireNonNull(file, "Cannot read null file"));){
            ClassNode classNode = ASMUtils.readClass(new ClassReader((InputStream)in));
            return classNode;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
    }

    public static ClassNode readClass(ZipFile jar, ZipEntry entry) throws IOException {
        Throwable throwable = null;
        try (InputStream in = jar.getInputStream(entry);){
            ClassNode classNode = ASMUtils.readClass(new ClassReader(Objects.requireNonNull(in, "Entry not present in jar")));
            return classNode;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
    }

    private static ClassNode readClass(ClassReader reader) {
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 4);
        return node;
    }
}

