/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.modmuss50.optifabric.shadow.tinyremapper.IMappingProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

public class RemappingUtils {
    private static final MappingResolver RESOLVER = FabricLoader.getInstance().getMappingResolver();
    private static final String INTERMEDIARY = "intermediary";
    private static final Pattern CLASS_FINDER = Pattern.compile("Lnet\\/minecraft\\/([^;]+);");

    public static boolean hasClassName(String className) {
        className = !INTERMEDIARY.equals(RESOLVER.getCurrentRuntimeNamespace()) ? RemappingUtils.fromIntermediaryDot(className) : "net.minecraft.".concat(className);
        return !className.equals(RESOLVER.unmapClassName("official", className));
    }

    public static String getClassName(String className) {
        return RemappingUtils.fromIntermediaryDot(className).replace('.', '/');
    }

    private static String fromIntermediaryDot(String className) {
        return RESOLVER.mapClassName(INTERMEDIARY, "net.minecraft.".concat(String.valueOf(className)));
    }

    public static IMappingProvider.Member mapMethod(String owner, String name, String desc) {
        return new IMappingProvider.Member(RemappingUtils.getClassName(owner), RemappingUtils.getMethodName(owner, name, desc), RemappingUtils.mapMethodDescriptor(desc));
    }

    public static String getMethodName(String owner, String methodName, String desc) {
        return RESOLVER.mapMethodName(INTERMEDIARY, "net.minecraft.".concat(String.valueOf(owner)), methodName, desc);
    }

    public static String mapMethodDescriptor(String desc) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = CLASS_FINDER.matcher(desc);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + RemappingUtils.getClassName(matcher.group(1)) + ';'));
        }
        return matcher.appendTail(buf).toString();
    }

    public static String mapFieldName(String owner, String name, String desc) {
        return RESOLVER.mapFieldName(INTERMEDIARY, "net.minecraft.".concat(owner), name, desc);
    }
}

