/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static boolean isValid(File zip) throws IOException {
        try {
            new ZipFile(zip).close();
            return true;
        }
        catch (ZipError | ZipException throwable) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void iterateContents(File zip, ZipVisitor visitor) {
        try {
            ZipFile origin;
            block12: {
                origin = new ZipFile(zip);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> it = origin.entries();
                    while (it.hasMoreElements() && visitor.visit(origin, it.nextElement())) {
                    }
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable4 = throwable2;
                        throwable = throwable2;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            origin.close();
                            throw throwable5;
                        }
                        try {
                            origin.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                }
                try {
                    origin.close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            origin.close();
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error iterating ".concat(String.valueOf(zip)), e);
        }
    }

    public static void extract(File zip, File to) {
        ZipUtils.iterateContents(zip, (zipFile, entry) -> {
            String name = entry.getName();
            File extract = new File(to, name);
            if (name.indexOf("..") >= 0 && !extract.getCanonicalPath().startsWith(to.getCanonicalPath())) {
                throw new SecurityException("The file \"" + name + "\" (in " + zip + ") tried to leave the output directory: " + to);
            }
            if (entry.isDirectory()) {
                FileUtils.forceMkdir((File)extract);
            } else {
                FileUtils.forceMkdir((File)extract.getParentFile());
                FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(entry), (File)extract);
            }
            return true;
        });
    }

    public static void filter(File zipOrigin, ZipVisitor filter, File zipDestination) {
        ZipUtils.transform(zipOrigin, filter, zipDestination);
    }

    public static void filterInPlace(File zip, ZipVisitor filter) {
        ZipUtils.transformInPlace(zip, filter);
    }

    public static void transform(File zipOrigin, ZipTransformer transformer, File zipDestination) {
        try {
            ZipUtils.transform(zipOrigin, 1, transformer, zipDestination);
            return;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)zipDestination);
            throw new UncheckedIOException("Error transforming ".concat(String.valueOf(zipOrigin)), e);
        }
    }

    public static void transformInPlace(File zip, ZipTransformer transformer) {
        File tempZip = null;
        try {
            tempZip = File.createTempFile("optifabric", ".zip");
            ZipUtils.transform(zip, 5, transformer, tempZip);
            if (zip.exists() && !zip.delete()) {
                throw new IllegalStateException("Failed to clear ".concat(String.valueOf(zip)));
            }
            FileUtils.moveFile((File)tempZip, (File)zip);
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error modifying ".concat(String.valueOf(zip)), e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempZip);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void transform(File zipOrigin, int originFlags, ZipTransformer transformer, File zipDestination) throws IOException {
        ZipFile origin;
        block32: {
            origin = new ZipFile(zipOrigin, originFlags);
            Throwable throwable = null;
            try {
                Throwable throwable2 = null;
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipDestination)));){
                    boolean pure = transformer instanceof ZipVisitor;
                    Enumeration<? extends ZipEntry> it = origin.entries();
                    while (it.hasMoreElements()) {
                        ZipEntry entry = it.nextElement();
                        InputStream in = transformer.apply(origin, entry);
                        Throwable throwable3 = null;
                        try {
                            if (in == null) continue;
                            out.putNextEntry(pure ? new ZipEntry(entry) : new ZipEntry(transformer.mapName(entry)));
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable3 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable8 = throwable5;
                    throwable2 = throwable5;
                    throw throwable8;
                }
                if (throwable == null) break block32;
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable11 = throwable6;
                    throwable = throwable6;
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    if (throwable == null) {
                        origin.close();
                        throw throwable12;
                    }
                    try {
                        origin.close();
                        throw throwable12;
                    }
                    catch (Throwable throwable13) {
                        throwable.addSuppressed(throwable13);
                        throw throwable12;
                    }
                }
            }
            try {
                origin.close();
                return;
            }
            catch (Throwable throwable9) {
                throwable.addSuppressed(throwable9);
                return;
            }
        }
        origin.close();
    }

    public static interface ZipVisitor
    extends ZipTransformer {
        @Override
        default public InputStream apply(ZipFile zip, ZipEntry entry) throws IOException {
            if (this.visit(zip, entry)) {
                return zip.getInputStream(entry);
            }
            return null;
        }

        public boolean visit(ZipFile var1, ZipEntry var2) throws IOException;
    }

    public static interface ZipTransformer {
        public InputStream apply(ZipFile var1, ZipEntry var2) throws IOException;

        default public String mapName(ZipEntry entry) {
            return entry.getName();
        }
    }
}

