/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3616;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import pro.mikey.fabric.xray.ScanController;
import pro.mikey.fabric.xray.StateSettings;
import pro.mikey.fabric.xray.cache.BlockSearchEntry;
import pro.mikey.fabric.xray.records.BasicColor;
import pro.mikey.fabric.xray.records.BlockPosWithColor;
import pro.mikey.fabric.xray.render.RenderOutlines;
import pro.mikey.fabric.xray.storage.BlockStore;
import pro.mikey.fabric.xray.storage.SettingsStore;

@Environment(value=EnvType.CLIENT)
public class ScanTask
implements Runnable {
    private static AtomicBoolean isScanning = new AtomicBoolean(false);

    ScanTask() {
    }

    @Nullable
    public static BasicColor isValidBlock(class_2338 pos, class_1937 world, Set<BlockSearchEntry> blocks) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return null;
        }
        if (SettingsStore.getInstance().get().isShowLava() && state.method_26227().method_15772() instanceof class_3616) {
            return new BasicColor(210, 10, 10);
        }
        class_2680 defaultState = state.method_26204().method_9564();
        return blocks.stream().filter(localState -> localState.isDefault() && defaultState == localState.getState() || !localState.isDefault() && state == localState.getState()).findFirst().map(BlockSearchEntry::getColor).orElse(null);
    }

    @Override
    public void run() {
        if (isScanning.get()) {
            return;
        }
        isScanning.set(true);
        Set<BlockPosWithColor> c = this.collectBlocks();
        ScanController.renderQueue.clear();
        ScanController.renderQueue.addAll(c);
        isScanning.set(false);
        RenderOutlines.requestedRefresh.set(true);
    }

    private Set<BlockPosWithColor> collectBlocks() {
        Set<BlockSearchEntry> blocks = BlockStore.getInstance().getCache().get();
        if (blocks.isEmpty() && !SettingsStore.getInstance().get().isShowLava()) {
            if (!ScanController.renderQueue.isEmpty()) {
                ScanController.renderQueue.clear();
            }
            return new HashSet<BlockPosWithColor>();
        }
        class_310 instance = class_310.method_1551();
        class_638 world = instance.field_1687;
        class_746 player = instance.field_1724;
        if (world == null || player == null) {
            return new HashSet<BlockPosWithColor>();
        }
        HashSet<BlockPosWithColor> renderQueue = new HashSet<BlockPosWithColor>();
        int cX = player.method_31476().field_9181;
        int cZ = player.method_31476().field_9180;
        int range = StateSettings.getHalfRange();
        for (int i = cX - range; i <= cX + range; ++i) {
            int chunkStartX = i << 4;
            for (int j = cZ - range; j <= cZ + range; ++j) {
                int chunkStartZ = j << 4;
                for (int k = chunkStartX; k < chunkStartX + 16; ++k) {
                    for (int l = chunkStartZ; l < chunkStartZ + 16; ++l) {
                        for (int m = world.method_31607(); m < world.method_31600() + 16; ++m) {
                            class_2338 pos = new class_2338(k, m, l);
                            BasicColor validBlock = ScanTask.isValidBlock(pos, (class_1937)world, blocks);
                            if (validBlock == null) continue;
                            renderQueue.add(new BlockPosWithColor(pos, validBlock));
                        }
                    }
                }
            }
        }
        return renderQueue;
    }
}

