/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray.records;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import pro.mikey.fabric.xray.cache.BlockSearchEntry;
import pro.mikey.fabric.xray.records.BasicColor;

@Environment(value=EnvType.CLIENT)
public class BlockEntry {
    private class_2680 state;
    private class_1799 stack;
    private String name;
    private BasicColor color;
    private int order;
    private boolean isDefault;
    private boolean active;

    public BlockEntry(class_2680 state, String name, BasicColor color, int order, boolean isDefault, boolean active) {
        this.state = state;
        this.stack = new class_1799((class_1935)this.state.method_26204());
        this.name = name;
        this.color = color;
        this.order = order;
        this.isDefault = isDefault;
        this.active = active;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setState(class_2680 state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BasicColor getHex() {
        return this.color;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    public void setColor(BasicColor color) {
        this.color = color;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Serializer
    implements JsonSerializer<BlockEntry>,
    JsonDeserializer<BlockEntry> {
        public BlockEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject asJsonObject = json.getAsJsonObject();
            return new BlockEntry(BlockSearchEntry.blockStateFromStringNBT(asJsonObject.get("state").getAsString()), asJsonObject.get("name").getAsString(), BasicColor.of(asJsonObject.get("color").getAsString()), asJsonObject.get("order").getAsInt(), asJsonObject.get("isDefault").getAsBoolean(), asJsonObject.get("active").getAsBoolean());
        }

        public JsonElement serialize(BlockEntry src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("state", class_2512.method_10686((class_2680)src.getState()).toString());
            object.addProperty("name", src.name);
            object.addProperty("color", src.color.toHex());
            object.addProperty("order", (Number)src.order);
            object.addProperty("isDefault", Boolean.valueOf(src.isDefault));
            object.addProperty("active", Boolean.valueOf(src.active));
            return object;
        }
    }
}

