/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.command.CraftingTweaksCommand;
import net.blay09.mods.craftingtweaks.compat.VanillaCraftingGridProvider;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.crafting.ShapedRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.crafting.ShapelessRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.network.HelloMessage;
import net.blay09.mods.craftingtweaks.network.ModNetworking;
import net.blay09.mods.craftingtweaks.registry.JsonCompatLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import net.minecraft.class_8710;
import net.minecraft.class_9695;

public class CraftingTweaks {
    public static final String MOD_ID = "craftingtweaks";
    public static boolean debugMode;
    public static boolean isServerSideInstalled;

    public static void initialize() {
        CraftingTweaksConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.getCommands().register(CraftingTweaksCommand::register);
        Balm.addServerReloadListener((class_2960)class_2960.method_60655((String)MOD_ID, (String)"json_registry"), (class_3302)new JsonCompatLoader());
        CraftingTweaksAPI.registerCraftingGridProvider(new VanillaCraftingGridProvider());
        CraftingTweaksAPI.registerRecipeMatrixMapper(class_1869.class, new ShapedRecipeMatrixMapper());
        CraftingTweaksAPI.registerRecipeMatrixMapper(class_1867.class, new ShapelessRecipeMatrixMapper());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((class_1657)event.getPlayer(), (class_8710)new HelloMessage()));
        Balm.getEvents().onEvent(ItemCraftedEvent.class, event -> {
            class_1657 player = event.getPlayer();
            class_1937 level = player.method_37908();
            class_1263 craftMatrix = event.getCraftMatrix();
            class_1863 recipeManager = level.method_8433();
            if (craftMatrix instanceof class_8566) {
                class_8566 craftingContainer = (class_8566)craftMatrix;
                Optional optionalRecipeHolder = recipeManager.method_8132(class_3956.field_17545, (class_9695)craftingContainer.method_59961(), level);
                optionalRecipeHolder.ifPresent(recipeHolder -> CraftingTweaksAPI.setLastCraftedRecipe(player, recipeHolder));
            }
        });
    }

    static {
        isServerSideInstalled = true;
    }
}

