/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.InternalMethods;
import net.blay09.mods.craftingtweaks.api.RecipeMatrixMapper;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class CraftingTweaksAPI {
    private static final InternalMethods internalMethods = CraftingTweaksAPI.loadInternalMethods();

    private static InternalMethods loadInternalMethods() {
        try {
            return (InternalMethods)Class.forName("net.blay09.mods.craftingtweaks.api.impl.InternalMethodsImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load Crafting Tweaks API", e);
        }
    }

    public static void registerCraftingGridProvider(CraftingGridProvider provider) {
        internalMethods.registerCraftingGridProvider(provider);
    }

    public static void unregisterCraftingGridProvider(CraftingGridProvider provider) {
        internalMethods.unregisterCraftingGridProvider(provider);
    }

    public static <C extends class_9695, T extends class_1860<C>> void registerRecipeMatrixMapper(Class<T> recipeClass, RecipeMatrixMapper<T> recipeMatrixMapper) {
        internalMethods.registerRecipeMatrixMapper(recipeClass, recipeMatrixMapper);
    }

    public static <C extends class_9695, T extends class_1860<C>> RecipeMatrixMapper<T> getRecipeMatrixMapper(Class<T> recipe) {
        return internalMethods.getRecipeMatrixMapper(recipe);
    }

    public static Optional<class_8786<?>> getLastCraftedRecipe(class_1657 player) {
        return internalMethods.getLastCraftedRecipe(player);
    }

    public static <T extends class_1860<? extends class_9695>> void setLastCraftedRecipe(class_1657 player, class_8786<T> recipe) {
        internalMethods.setLastCraftedRecipe(player, recipe);
    }
}

